/*
 * Decompiled with CFR 0.152.
 */
package HSR.Formular.GUI;

import HSR.Formular.GUI.FormularFileFilter;
import HSR.Formular.GUI.FormularView;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SaveDialog
extends JDialog {
    private JList fileList;
    private JTextField fileEdit = new JTextField();
    private JButton cancelB = new JButton();
    private JButton okB = new JButton();
    private FormularView view;
    private String[] liste = new String[1];

    public SaveDialog(FormularView v) {
        this.view = v;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        File file = new File(this.view.getPfad());
        if (file.isDirectory()) {
            this.liste = file.list(new FormularFileFilter());
        }
        this.fileList = new JList<String>(this.liste);
        this.fileList.setBounds(new Rectangle(15, 15, 470, 302));
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SaveDialog.this.onFileList();
            }
        });
        this.getContentPane().setLayout(null);
        this.fileEdit.setText("unbenannt.kszh");
        this.fileEdit.setBounds(new Rectangle(15, 337, 470, 21));
        this.cancelB.setText("Cancel");
        this.cancelB.setBounds(new Rectangle(405, 368, 80, 27));
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveDialog.this.onCancel();
            }
        });
        this.okB.setText("OK");
        this.okB.setBounds(new Rectangle(15, 368, 80, 27));
        this.okB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveDialog.this.onOK();
            }
        });
        this.getContentPane().add((Component)this.fileList, null);
        this.getContentPane().add((Component)this.fileEdit, null);
        this.getContentPane().add((Component)this.okB, null);
        this.getContentPane().add((Component)this.cancelB, null);
        Rectangle rect = this.view.getBounds();
        ((Component)this).setBounds(rect.x + (rect.width - 504) / 2, rect.y + (rect.height - 438) / 2, 504, 438);
        this.setTitle("speichern unter...");
        this.setModal(true);
    }

    private void onOK() {
        if (this.fileEdit.getText() != "") {
            if (this.isFileVorhanden(this.fileEdit.getText())) {
                if (JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(new StringBuffer("Wollen Sie die Datei ").append(this.fileEdit.getText()).append(" \u00fcberschreiben?"))), "Frage?", 1) == 0) {
                    this.view.save(this.fileEdit.getText());
                    this.hide();
                }
            } else {
                this.view.save(this.fileEdit.getText());
                this.hide();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Sie m\u00fcssenen einen Dateinamen angeben!", "Achtung!", 2);
        }
    }

    private boolean isFileVorhanden(String file) {
        String fileMitExt = String.valueOf(String.valueOf(file)).concat(".kszh");
        for (int i = 0; i < this.liste.length; ++i) {
            if (this.liste[i].equals(file)) {
                return true;
            }
            if (!this.liste[i].equals(fileMitExt)) continue;
            return true;
        }
        return false;
    }

    private void onFileList() {
        this.fileEdit.setText((String)this.fileList.getSelectedValue());
    }

    private void onCancel() {
        this.hide();
    }
}

