/*
 * Decompiled with CFR 0.152.
 */
package HSR.Formular.GUI;

import HSR.Formular.GUI.FormularPageView;
import HSR.Formular.PD.Felder.AbstrakteFelder.AbstractFeldKlasse;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class TextFeldView
extends JTextField
implements Observer {
    final int OFFSET = 5;
    private AbstractFeldKlasse model;
    private FormularPageView view;
    private boolean isMouseOverField = false;

    public TextFeldView(FormularPageView v, AbstractFeldKlasse m) {
        this.view = v;
        this.model = m;
        Rectangle rect = this.model.getPosition();
        this.model.updateInitValue();
        this.setBounds(rect.x + 5, rect.y + 5, rect.width, rect.height);
        this.setEditable(this.model.getEditierbar());
        this.setHorizontalAlignment(this.model.getAlignment());
        this.setText(this.model.toString());
        this.setToolTipText(this.model.getTooltip());
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TextFeldView.this.isMouseOverField = true;
                TextFeldView.this.view.repaint();
            }

            public void mouseExited(MouseEvent e) {
                TextFeldView.this.isMouseOverField = false;
                TextFeldView.this.view.repaint();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TextFeldView.this.view.setVisible(TextFeldView.this.getBounds());
                TextFeldView.this.view.repaint();
            }

            public void focusLost(FocusEvent e) {
                TextFeldView.this.onEdit();
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextFeldView.this.onEdit();
            }
        });
        this.model.addObserver(this);
    }

    public void paintComponent(Graphics graphic) {
        FontMetrics fm;
        Rectangle2D rectString;
        Rectangle rect = this.getBounds();
        Graphics2D g2 = (Graphics2D)graphic;
        Font font = this.getFont();
        if (this.hasFocus() && this.isEditable()) {
            this.setBackground(Color.yellow);
        } else {
            this.setBackground(new Color(255, 255, 255, 0));
            g2.drawImage(this.view.getImage(), 0, 0, rect.width, rect.height, rect.x - 5, rect.y - 5, rect.x - 5 + rect.width, rect.y - 5 + rect.height, this);
        }
        if (font.getSize() < 9) {
            this.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 1));
        }
        if ((rectString = (fm = ((Component)this).getFontMetrics(this.getFont())).getStringBounds(this.getText(), g2)).getHeight() > (double)(rect.height - 2) || rectString.getWidth() > (double)(rect.width - 4)) {
            while (rectString.getHeight() > (double)(rect.height - 2) || rectString.getWidth() > (double)(rect.width - 4)) {
                font = this.getFont();
                this.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 1));
                fm = ((Component)this).getFontMetrics(this.getFont());
                rectString = fm.getStringBounds(this.getText(), g2);
            }
        }
        super.paintComponent(graphic);
    }

    public void paintBorder(Graphics graphic) {
        Rectangle rect = this.getBounds();
        Graphics2D g2 = (Graphics2D)graphic;
        if (this.isMouseOverField && this.isEditable()) {
            g2.setColor(Color.blue);
            g2.setStroke(new BasicStroke(2.0f));
            g2.draw(new Rectangle(1, 1, rect.width - 2, rect.height - 2));
        }
    }

    public void update(Observable m, Object arg) {
        this.setText(this.model.toString());
        this.setEditable(this.model.getEditierbar());
    }

    public void onEdit() {
        try {
            this.model.setFeldValue(this.getText());
        }
        catch (Exception e) {
            this.setText("");
            JOptionPane.showMessageDialog(null, e.getMessage(), "Fehler!", 0);
        }
        this.view.repaint();
    }

    public int getFeldNummer() {
        return this.model.getFeldNummer();
    }
}

