/*
 * Decompiled with CFR 0.152.
 */
package HSR.Formular.PD.Felder.AbstrakteFelder;

import HSR.Formular.PD.Felder.AbstrakteFelder.AbstractFeldKlasse;
import HSR.Formular.PD.Felder.Exception.NotANumberException;
import HSR.Formular.PD.Felder.FeldParameter;
import java.text.DecimalFormat;
import java.util.Map;

public abstract class ZahlFeldKlasse
extends AbstractFeldKlasse {
    private boolean ohneRappen = false;
    private boolean negValue = true;
    private boolean negGewichtung = false;
    protected boolean autoFeld = true;
    public static final int ERLAUBE_NEG_VALUE = 2;
    public static final int VERBIETE_RAPPEN = 16;
    public static final int GEWICHTE_FELD_NEGATIV = 32;

    public void setProperties(FeldParameter p) {
        while (p.hasNext()) {
            Map.Entry m = p.next();
            switch ((Integer)m.getKey()) {
                case 2: {
                    if (((Boolean)m.getValue()).booleanValue()) {
                        this.negValue = true;
                        break;
                    }
                    this.negValue = false;
                    break;
                }
                case 16: {
                    if (((Boolean)m.getValue()).booleanValue()) {
                        this.ohneRappen = true;
                        break;
                    }
                    this.ohneRappen = false;
                    break;
                }
                case 32: {
                    this.negGewichtung = (Boolean)m.getValue() != false;
                }
            }
        }
    }

    public boolean getProperties(int Properties2) {
        switch (Properties2) {
            case 32: {
                return this.negGewichtung;
            }
            case 16: {
                return this.ohneRappen;
            }
            case 2: {
                return this.negValue;
            }
        }
        return false;
    }

    public ZahlFeldKlasse() {
        this.setFeldValue(0.0);
    }

    public boolean setFeldValue(double FeldValue) {
        Double oldFeldValue = null;
        try {
            oldFeldValue = new Double(this.getFeldValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oldFeldValue == null) {
            oldFeldValue = new Double(0.0);
        }
        if (!this.negValue && FeldValue < 0.0) {
            FeldValue = -FeldValue;
        }
        if (this.ohneRappen) {
            FeldValue = new Double(FeldValue).intValue();
        }
        Double newFeldValue = new Double(FeldValue);
        boolean t = super.setObjectFeldValue(newFeldValue);
        this.NofityPropertyChangeListeners(newFeldValue, oldFeldValue);
        if (t && (newFeldValue != 0.0 && oldFeldValue == 0.0 || newFeldValue == 0.0 && oldFeldValue != 0.0)) {
            this.notifyEnableChangeFelder();
        }
        return t;
    }

    public boolean setFeldValue(String FeldValue) throws Exception {
        double d;
        if (FeldValue.length() == 0) {
            d = 0.0;
        } else {
            try {
                String format = "###,###,###,###,###,###,###.##";
                DecimalFormat df = new DecimalFormat(format);
                d = df.parse(FeldValue).doubleValue();
            }
            catch (Exception e) {
                throw new NotANumberException(FeldValue);
            }
        }
        return this.setFeldValue(d);
    }

    public double getFeldValue() {
        double FeldValue = (Double)super.getObjectFeldValue();
        if (this.ohneRappen) {
            FeldValue = new Double(FeldValue).intValue();
        }
        return FeldValue;
    }

    public String toString() {
        String format = this.ohneRappen ? "###,###,##0" : "###,###,##0.00";
        DecimalFormat df = new DecimalFormat(format);
        return df.format(this.getFeldValue());
    }

    static {
        ERLAUBE_NEG_VALUE = 2;
        VERBIETE_RAPPEN = 16;
        GEWICHTE_FELD_NEGATIV = 32;
    }
}

