/*
 * Decompiled with CFR 0.152.
 */
package HSR.Formular.PD;

import HSR.Formular.PD.Felder.AbstrakteFelder.RFFeld;
import HSR.Formular.PD.Formular;
import HSR.Formular.PD.FormularPage;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class FormularPrinter
extends Component
implements Printable {
    private Formular formular;
    private int pageCount;
    private int width;
    private int height;
    private double faktor;

    public FormularPrinter(Formular f, int pc) {
        this.formular = f;
        this.pageCount = pc;
    }

    public void printFormular(Graphics g, FormularPage page) {
        Image image = page.getImage();
        try {
            this.faktor = (double)this.width / (double)image.getWidth(this);
            if ((double)this.height / (double)image.getHeight(this) < this.faktor) {
                this.faktor = (double)this.height / (double)image.getHeight(this);
            }
            g.drawImage(image, 0, 0, this.runden((double)image.getWidth(this) * this.faktor), this.runden((double)image.getHeight(this) * this.faktor), this);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void printFields(Graphics g, FormularPage page) {
        try {
            RFFeld feld = page.getFirstField();
            while (feld != null) {
                Rectangle rect = this.calcPosition(feld);
                String wert = feld.toString();
                if (wert.endsWith("true")) {
                    Image image = page.getCross();
                    g.drawImage(image, rect.x, rect.y, rect.width, rect.height, this);
                } else if (!wert.endsWith("false")) {
                    Font font = g.getFont();
                    FontMetrics fm = g.getFontMetrics(g.getFont());
                    Rectangle2D rectString = fm.getStringBounds(wert, g);
                    if (rectString.getHeight() > (double)(rect.height + 2) || rectString.getWidth() > (double)rect.width) {
                        while (rectString.getHeight() > (double)(rect.height + 2) || rectString.getWidth() > (double)rect.width) {
                            font = g.getFont();
                            g.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 1));
                            fm = g.getFontMetrics(g.getFont());
                            rectString = fm.getStringBounds(wert, g);
                        }
                    }
                    if (feld.getAlignment() == 2) {
                        g.drawString(wert, rect.x + 2, rect.y + rect.height - 1);
                    } else if (feld.getAlignment() == 0) {
                        g.drawString(wert, rect.x + this.runden(((double)rect.width - rectString.getWidth()) / (double)2), rect.y + rect.height - 1);
                    } else {
                        g.drawString(wert, rect.x + this.runden((double)rect.width - rectString.getWidth()) - 2, rect.y + rect.height - 1);
                    }
                }
                feld = page.getNextField();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private Rectangle calcPosition(RFFeld feld) {
        Rectangle rect = new Rectangle(feld.getPosition());
        rect.x = this.runden((double)rect.x * this.faktor);
        rect.y = this.runden((double)rect.y * this.faktor);
        rect.width = this.runden((double)rect.width * this.faktor);
        rect.height = this.runden((double)rect.height * this.faktor);
        return rect;
    }

    private int runden(double zahl) {
        int res = (int)zahl;
        if (zahl - (double)res >= 0.5) {
            ++res;
        }
        return res;
    }

    public int print(Graphics g, PageFormat pageFormat, int siteNumber) throws PrinterException {
        if (siteNumber >= this.pageCount) {
            return 1;
        }
        FormularPage page = this.formular.getPage(siteNumber);
        if (page != null) {
            this.width = (int)pageFormat.getImageableWidth();
            this.height = (int)pageFormat.getImageableHeight();
            g.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            this.printFormular(g, page);
            this.printFields(g, page);
            return 0;
        }
        return 1;
    }
}

